unit PolledMode;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DlsrLib_TLB, OleCtrls, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    SR: TDriverLINXSR;
    LDD: TDriverLINXLDD;
    cmdInit: TButton;
    cboDeviceNumber: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    lblStatus: TLabel;
    cmdSample: TButton;
    cmdScan: TButton;
    BitBtn1: TBitBtn;
    ListBox1: TListBox;
    txtSample: TEdit;
    GroupBox1: TGroupBox;
    optC: TRadioButton;
    optF: TRadioButton;
    procedure cmdInitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CloseDriver(Sender: TObject);
    procedure cmdSampleClick(Sender: TObject);
    procedure cmdScanClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.cmdInitClick(Sender: TObject);
begin
{
 This example was written in Delphi 3 Standard in Win95B
 with DAS-TC/B and DriverLINX version 4.0.0 installed from CD
 part number SF-041A01.

 It demonstrates two Polled mode tasks from a board
 - a single sample from channel 0
 - a scan from channels 0 through 7
}

{  DAS-TC/B has special gain codes for control of T/C type, averaging,
   CJC on/off, and C or F reporting.
   See the Analog Input Gain Codes section of the 'Using the DAS-TC/B
   with DriverLINX' document located in c:\driverlinx4\docs\notes\kdastc.pdf

     -32768 + 5 = B Type T/C Sensor
     -32768 + 6 = E Type T/C Sensor
     -32768 + 7 = J Type T/C Sensor
     -32768 + 8 = K Type T/C Sensor
     -32768 + 9 = R Type T/C Sensor
     -32768 + 10 = S Type T/C Sensor
     -32768 + 11 = T Type T/C Sensor
     -32768 + 13 = N Type T/C Sensor

     1x2^13 = 8192 = CJC On
     0x2^13 = 0 = CJC Off

     1x2^14 = 16384 = report in deg F
     0x2^14 = 0 = report in deg C

     n*2^6 = n*64 = average n measurements with each reported reading


     }

     // Open the driver
  SR.Req_DLL_name := 'kdastc$';
  // fill in driver name to avoid Open Driver dialog
  // append $ onto end to suppress Open Driver dialog
  // popup if supplied driver name not found on system

     // now init the hardware
     with SR do begin
      Req_device := cboDeviceNumber.ItemIndex; // same as the selected value for us
      Req_subsystem := DL_DEVICE;
      Req_mode := DL_OTHER;
      Req_op := DL_INITIALIZE;
      Refresh;
    if (SR.Res_result <> DL_NoErr) then
         begin
         // test for driver not loaded
         if (SR.Req_DLL_name = '') then
         lblStatus.Caption := 'Board must be a DAS-TC/B'
         else
         lblStatus.caption := SR.Message; // display error message
         end

  else
  begin
        // use of LDD is not mandatory
        // use it here to read out the model number of board
        LDD.Req_DLL_name := SR.req_dll_name;  // set LDD equal to
        LDD.device := SR.Req_device;         // our hardware
        LDD.Refresh;                         // get fresh data in LDD
        Form1.Caption := 'Polled AI with ' + LDD.Dev_Model;
        // now enable the other buttons now that hardware is init

        lblStatus.Caption := 'Board initialized OK';
        cmdSample.Enabled := True;
        cmdScan.Enabled := True;
        cmdInit.Enabled := False;  // disable Init button
   end;
     end;
     form1.SetFocus();  // return focus to our application
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     // load combox box with legal values for device number...0 - 5
cboDeviceNumber.Items.Add('0');
cboDeviceNumber.Items.Add('1');
cboDeviceNumber.Items.Add('2');
cboDeviceNumber.Items.Add('3');
cboDeviceNumber.Items.Add('4');
cboDeviceNumber.Items.Add('5');
cboDeviceNumber.ItemIndex := 0; // set it equal to first entry
end;

procedure TForm1.CloseDriver(Sender: TObject);
begin
SR.Req_DLL_name := '';  // Null String
LDD.Req_DLL_name := '';
end;

procedure TForm1.cmdSampleClick(Sender: TObject);
var
Units : integer;
Measurement : OleVariant;
tempStr : string[30];
samples : Double;
begin
     // set up a single sample from channel 0
     lblStatus.Caption := 'Starting the Single Sample....';
     
     // set up a single sample
     //Request Group
    SR.Req_subsystem := DL_AI;
    SR.Req_mode := DL_POLLED;  // do a Polled mode AI task
    SR.Req_op := DL_START;
    //Event Group
    SR.Evt_Str_type := DL_COMMAND; // start when Refresh is called
    SR.Evt_Stp_type := DL_TCEVENT;  // stop when buffer is filled
    SR.Evt_Tim_type := DL_NULLEVENT; // polled tasks have no timing

//Specify channels, gain and data format
    SR.Sel_chan_format := DL_tNATIVE;
    SR.Sel_chan_N := 1;    // only a start channel will be given
    SR.Sel_chan_start := 0;   // start on channel 0
    if (optC.Checked = True) then
      Units := 0  // deg C
      else
      Units := 16384;  // deg F

    // start gain code applies to first channel in start/stop range
    SR.Sel_chan_startGainCode := -32768+7 + 8192 + Units + (2*64);
                                // type J + CJC + C or F + avg 2 per report
    SR.Sel_buf_N := 0;  // for single sample, no buffer needed
    SR.Sel_buf_samples := 0;  // the .Res_sta_ioValue property of SR stores it
    SR.Refresh;

    Measurement := VarArrayCreate([0,1],VarSingle); // allocate an array
    // the ArrayBufferConvert method is gain setting aware
    // so best to use this to convert the raw codes in .Res_sta_ioValue
    // to a temperature according to the gain settings
    samples := SR.ArrayBufferConvert(0,0,1,Measurement,DL_tSingle,0,0);

    str(Measurement[0]:8:3,tempStr); // display the first value in array
    txtSample.Text := tempStr;
    lblStatus.caption := 'Single Sample task complete...';

     
end;

procedure TForm1.cmdScanClick(Sender: TObject);
var
i : integer;
samples : Double;
tempStr : string[10];
ADdata : OleVariant;  // buffer for the data
Units : integer;
begin
     listbox1.Clear;  // blank out any previous data
     lblStatus.Caption := 'Starting the Scan....';
     
     // set up a scan across 8 channels
     //Request Group
    SR.Req_subsystem := DL_AI;
    SR.Req_mode := DL_POLLED;  // do a Polled mode AI task
    SR.Req_op := DL_START;

//Events Group
    SR.Evt_Str_type := DL_COMMAND; // start when Refresh is called
    SR.Evt_Stp_type := DL_TCEVENT;  // stop when buffer is filled
    SR.Evt_Tim_type := DL_NULLEVENT; // polled tasks have no timing

//Specify channels, gain and data format
    SR.Sel_chan_format := DL_tNATIVE;
    SR.Sel_chan_N := 2;    // does NOT mean two channels. Means a start and stop channel
    SR.Sel_chan_start := 0;   // start on channel 0
    SR.Sel_chan_stop := 7;    // stop on channel 7.....8 channels total


      if (optC.Checked = True) then
      Units := 0  // deg C
      else
      Units := 16384;  // deg F

    // start gain code applies to first channel in start/stop range
    SR.Sel_chan_startGainCode := -32768+7 + 8192 + Units + (2*64);
                             // type J + CJC + C or F + avg 2 per report
    // stop gain code applies to all other channels in the range
    SR.Sel_chan_stopGainCode := -32768+7 + 8192 + Units + (2*64);

//Add buffer info
    SR.Sel_buf_samples := 8;   //one sample per channel
    // polled mode operations can scan through the channels ONE time only
    // buffer must be equal to the number of channels in the scan
    // for repetitive scans of the channels, DL_INTERRUPT mode is required
    // and the Evt_Tim_Type properties for specification of scan rate
    // need to be added to this example.
    SR.Sel_buf_N := 1;         //one buffer
    SR.Sel_buf_notify := DL_NOEVENTS; //send no events
    SR.Refresh;
    // since polled mode execution of code halts here until task is done
    // we can go right into reading the data...no delay required

    // allocate array for the A/D results
   ADdata := VarArrayCreate([0,100],VarSingle);
       
   samples := SR.ArrayBufferConvert(0,0,8,ADdata,DL_tSingle,0,0);
   // samples will be zero if convert method was successful
   
   for i := 0 to 7 do   // display the data
   begin
   str(ADdata[i]:8:3,tempStr);
   listbox1.Items.Add(tempStr);  // populate list box
   end;
   lblStatus.caption := 'AI task complete...';

end;

end.
